import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../util/processResponse.js";

const initialState = {
    orderLoading: false,
    message: "",
    orderDetails: {},
};

export const postOrders = createAsyncThunk("orders/postOrders", async (obj) => {
    const { access_token, orderPostUrl, orderData } = obj;
    try {
        const res = await mutationResponse(
            orderPostUrl,
            "POST",
            orderData,
            access_token
        );
        return res;
    } catch (err) {}
});

const postOrdersSlice = createSlice({
    name: "orders",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(postOrders.pending, (state) => {
            state.orderLoading = true;
        });
        builder.addCase(postOrders.fulfilled, (state, { payload }) => {
            const { status: { code, message } = {}, records } = payload || {};
            if (code === 200) {
                state.message = message;
                state.orderDetails = records?.data;
            }
            state.orderLoading = false;
        });
        builder.addCase(postOrders.rejected, (state) => {
            state.orderLoading = false;
        });
    },
});

export default postOrdersSlice.reducer;
